/*
  db {
    bookmarks[] {
      id : integer
      title : string
      name : string
    }
    lastupdated : timestamp
  }

*/


var favoris = {
  db:{ bookmarks:[], lastUpdated:0},
  
  // Ajoute ou met à jour       
  add:function(url, title, name){
    if(!name){
      name = this.createName(url);
    }
    var i = this.indexOf(url);
    if(i == -1){ // L'entrée n'existe pas.
      this.db.bookmarks.push({
        id: this.getId(url),
        title: title,
        name: name
      });
    } else { // L'entrée existe, on met à jour.
      this.db.bookmarks[i]({
        id: this.getId(url),
        title: title,
        name: name
      });
    }
    this.db.lastUpdated = Date.now();
    this.save();
  },

  // Enlève des favoris
  remove:function(url){
    var d = this.indexOf(url);
    this.db.bookmarks.splice(d, 1);
    this.db.lastUpdated = Date.now();
    this.save();
  },

  // Extrait l'id du lien
  getId:function(url){
    var regex = /\/threads\/([0-9]+)/gi;
    if(result = regex.exec(url)) {
      return parseInt(result[1] ,10);
    } 
    return false;
  },

  // Crée un nom unique 
  createName:function(url){
    var regex = /(?:-(\S))/gi; 
    var ret = '';
    while(result = regex.exec(url)) {
      ret += result[1];
    } 
    return ret || 'vide';
  },

  // Retourne l'index d'une url dans les bookmarks
  indexOf:function(url){
    var id = this.getId(url);
    for(var i = 0, bm; bm = this.db.bookmarks[i]; i++){
      if(id === bm.id){
        return i;
      }
    }
    return -1;
  },

  // Sauvegarde dans le local Storage
  save:function(){
    localStorage.bookmarksContent = JSON.stringify(this.db);
  },
  
  // Restaure du local Storage
  load:function(){
    if(localStorage.bookmarksContent){
      this.db = JSON.parse(localStorage.bookmarksContent);
    }
  },
}