var ls = localStorage; 
var requestTimeout = 1000 * 6;
var usercpUrl = {
  'cpc' : 'http://forum.canardpc.com/',
  'x86' : 'http://forum2.x86-secret.com/'
};

// Initialisation des variables
function install(){
  ls.accesUrl = ls.accesUrl || usercpUrl['cpc'];
  ls.update = ls.update || 5;
  ls.popup = ls.popup || 1;
  ls.bookmarksEnabled = ls.bookmarksEnabled || 1;
  ls.cache = ls.cache || '';
  ls.bookmarksContent = ls.bookmarksContent || '{"bookmarks":[], "lastUpdated":0}';
  ls.persistentStorage = ls.persistentStorage || '{}';
}

// Initialisation de l'extension
function init(){
  install();
  chrome.alarms.create('refresh', {periodInMinutes: parseInt(ls.update, 10)});
  if(ls.popup === '1'){
    chrome.browserAction.setPopup({popup: "popup.html"});
    chrome.browserAction.onClicked.removeListener(goToUsercp);
  } else {
    chrome.browserAction.setPopup({popup: ""});
    chrome.browserAction.onClicked.addListener(goToUsercp);
  }
  refreshCounter();
}

// Ouvre le control panel dans un nouvel onglet
function goToUsercp(){
  chrome.tabs.getAllInWindow(undefined, function(tabs) {
    for (var i = 0, tab; tab = tabs[i]; i++) {
      if (tab.url && tab.url.indexOf(ls.accesUrl + 'usercp.php') == 0) {
        chrome.tabs.update(tab.id, {selected: true});
        chrome.tabs.reload(tab.id);
        return;
      }
    }
    chrome.tabs.create({url: ls.accesUrl + 'usercp.php'});
  });
}

// Dclenchement periodique
function onAlarm(){
  refreshCounter();
}

// Rcupre la page et rafraichi le bouton
function refreshCounter(wait) {
  var xhr = new XMLHttpRequest();
  var abortTimerId = window.setTimeout(function() {
    xhr.abort();  // synchronously calls onreadystatechange
  }, requestTimeout);
  function handleSuccess(page) {
    window.clearTimeout(abortTimerId);

    // Extrait le nombre de Thread non lu
    function parseNbThread(string){
      var pattern=/messages\: \(([0-9]+)\)/;
      return parseInt(string.match(pattern)[1], 10);
    }

    // Extrait le nombre de message non lu
    function parseNbMsg(string){
      var toReturn = 0;
      var pattern=/messages privs<\/a> \(([0-9]+)\)/;
      var result = string.match(pattern);
      if(result){
        toReturn = parseInt(result[1], 10);
      }
      pattern=/Nouveaux messages visiteur<\/a> \(([0-9]+)\)/;
      result = string.match(pattern);
      if(result){
        toReturn += parseInt(result[1], 10);
      }
      return toReturn;
    }

    // Choisi l'icone en fonction du nombre de messages
    function quelIcone(nbMsg){
      if(nbMsg == 0) return 2;
      if(nbMsg < 5)  return 3;
      if(nbMsg >= 5) return 4;
      return 1;
    }

    // Cre le texte de l'infobulle en fonction du nombre de messages
    function makeTitle(nbMsg, nbThread){
      var output = "";
      if(nbMsg) { output = nbMsg + " message(s)" ;}
      if(output && nbThread)  { output += ", ";}
      if(nbThread) { output += nbThread + " discussion(s)";}
      if(output == "") {output = "Rien, Nada ...";}
      return output;
    }
    var nbThread = parseNbThread(page);
    var nbMsg = parseNbMsg(page);
    ps.set('nbThread', nbThread);
    ps.set('nbMsg', nbMsg);
    bouton.update(quelIcone(nbMsg + nbThread), nbThread, nbMsg, makeTitle(nbMsg, nbThread));
  }

  function handleError(error) {
    window.clearTimeout(abortTimerId);
    bouton.update(1, ps.get('nbThread'), ps.get('nbMsg'), error);
  }

  try {
    xhr.onreadystatechange = function() {
      if (xhr.readyState != 4)
        return;

      if (xhr.responseText && xhr.status == 200) {
        var html = xhr.responseText;
        var debut = html.indexOf('<div class="cp_content">');
        if(debut !== -1){ // Si logg sur le forum
          var fin = html.indexOf('<!-- ############## END SUBSCRIBED THREADS ##############  -->');
          ls.cache = html.substring(debut, fin);
          handleSuccess(ls.cache);
        } else { // Si pas logg
          handleError("Non connect");
        }
      } else {
        handleError("Erreur Rseau");
      }
    };

    xhr.onerror = function(error) {
      handleError("Erreur Rseau");
      console.error("Xhr Error");
    };

    xhr.open("GET", ls.accesUrl + "usercp.php", !wait);
    xhr.send(null);
  } catch(e) {
    handleError("Erreur Rseau");
    console.error("Refresh Exception Error");
  }
}

// Extrait les liens pour le popup
function extractLinks(page, quantity){
  var parseMessage = /<a href="(private.php\?do[^"]+)" [^>]+>([^<>]+)<\/a>/gmi;
  var parseMsgVisit = /<a class="title" href="(members\/[^"]+?tab=visitor_messaging#visitor_messaging)[^>]+>([^<>]+)<\/a>/gim;
  var parseThread = /<a class="title [^"]+"[ ]+href="(threads[^"]+)" [^>]+>([^<>]+)<\/a>/gmi;
  var result, pos;
  var messages = [];
  var threads = [];

  function htmlDecode(input){
    var e = document.createElement('div');
    e.innerHTML = input;
    return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
  }

  // Rcupration des messages
  while ((result = parseMessage.exec(page))) {
    messages.push({url:ls.accesUrl + htmlDecode(result[1]), text:htmlDecode(result[2])});
    parseMsgVisit.lastIndex = parseMessage.lastIndex;
  }

  // Rcupration des messages visiteurs
  while ((result = parseMsgVisit.exec(page))) {
    messages.push({url:ls.accesUrl + htmlDecode(result[1]), text:htmlDecode(result[2])});
    parseThread.lastIndex = parseMsgVisit.lastIndex;
  }

  // Rcupration des Threads
  while ((result = parseThread.exec(page))) {
    threads.push({url:ls.accesUrl + htmlDecode(result[1]) + '?goto=newpost', text:htmlDecode(result[2])});
  }
  return {messages:messages, threads:threads, quantity:quantity};
} 

// Persistant storage
var ps = {
  db: {},
  set: function(key, value){
    if(!this.db[key]){
      try{
        this.db = JSON.parse(ls.persistentStorage);
      }catch(e){}
    }
    this.db[key] = value;
    ls.persistentStorage = JSON.stringify(this.db);        
  },

  get: function(key){
    if(!this.db[key]){
      this.db = JSON.parse(ls.persistentStorage);
    }
    return this.db[key];
  }
}

//
// Dclaration des venements
//

// Si installation de l'extension on met les options par dfaut.
//chrome.runtime.onInstalled.addListener(install);
chrome.runtime.onInstalled.addListener(function(details) {
  switch(details.reason){
    case 'install':
      install();
      break;
    case 'update':
      //patch pour la prochaine version,  supprimer.
      if(ls.accesUrl.indexOf('usercp.php') != -1 ){
        ls.accesUrl = ls.accesUrl.replace('usercp.php', '');
      }
      install();
      break;
    case 'chrome_update':
      break;
  }
});

// Alarme dclencheuse de refresh
chrome.alarms.onAlarm.addListener(onAlarm); 
chrome.runtime.onConnect.addListener(function(port) {
  if(port.name == 'popup'){
    port.onDisconnect.addListener(function(){
      setTimeout(refreshCounter,  3 * 1000);
    });
    port.onMessage.addListener(function(request) {
      switch(request.action){
        case 'PopupOpen': 
          port.postMessage(extractLinks(ls.cache, {nbThread:ps.get('nbThread'), nbMsg:ps.get('nbMsg')}));
          break;
        case 'PopupRefresh':
          refreshCounter(true);
          port.postMessage(extractLinks(ls.cache, {nbThread:ps.get('nbThread'), nbMsg:ps.get('nbMsg')}));
          break;
      }
    });
  }
  if(port.name == 'option'){
    port.onDisconnect.addListener(function(){
      init();
    });
  }
 });
//
// L ou tout commence.
//

window.addEventListener('DOMContentLoaded', init, false);
